// NetBroadcasterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetBroadcaster.h"
#include "NetBroadcasterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CNetBroadcasterDlg * g_pNetBroadcasterDlg = NULL;

HANDLE g_push_share_record_video_threads[ 4 ] = { NULL, NULL, NULL, NULL };

BYTE * g_p_video_frame_buffers[ 4 ] = { NULL, NULL, NULL, NULL };

ULONG  g_n_video_frame_buffer_lens[ 4 ] = { 0, 0, 0, 0 };

BOOL   g_n_video_bIsKeyFrame[ 4 ] = { 0, 0, 0, 0 };

HANDLE g_h_video_share_record_thread_stop_events[ 4 ] = { NULL, NULL, NULL, NULL };

HANDLE g_h_video_share_record_thread_buffer_ready_events[ 4 ] = { NULL, NULL, NULL, NULL };

DWORD WINAPI on_push_share_record_video_buffer_0( LPVOID params )
{
	HANDLE events[ 2 ] = { g_h_video_share_record_thread_stop_events[ 0 ], 

						   g_h_video_share_record_thread_buffer_ready_events[ 0 ] };
	while( TRUE ) {		

		DWORD returns = WaitForMultipleObjects( 2, events, FALSE, INFINITE );

		if( returns == (WAIT_OBJECT_0) ) { break ; }

		if( returns == (WAIT_OBJECT_0 + 1) ) {

			EnterCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 0 ] );

			BYTE * pFrameBuffer = g_p_video_frame_buffers[ 0 ];

			ULONG  nFrameBufferSize = g_n_video_frame_buffer_lens[ 0 ] ;

			ULONG  bIsKeyFrame = g_n_video_bIsKeyFrame[ 0 ];

			if( g_pNetBroadcasterDlg->m_nNetworkServerStates_v[ 0 ] >= 0x00000001 ) {

				LeaveCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 0 ] );

				QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( g_pNetBroadcasterDlg->m_hNetworkServer[0], 0, pFrameBuffer, nFrameBufferSize, bIsKeyFrame );
			}
			else {

				LeaveCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 0 ] );
			}
		}
	}
	return 0x00000000;
}

DWORD WINAPI on_push_share_record_video_buffer_1( LPVOID params )
{
	HANDLE events[ 2 ] = { g_h_video_share_record_thread_stop_events[ 1 ], 

						   g_h_video_share_record_thread_buffer_ready_events[ 1 ] };
	while( TRUE ) {		

		DWORD returns = WaitForMultipleObjects( 2, events, FALSE, INFINITE );

		if( returns == (WAIT_OBJECT_0) ) { break ; }

		if( returns == (WAIT_OBJECT_0 + 1) ) {

			EnterCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 1 ] );

			BYTE * pFrameBuffer = g_p_video_frame_buffers[ 1 ];

			ULONG  nFrameBufferSize = g_n_video_frame_buffer_lens[ 1 ] ;

			ULONG  bIsKeyFrame = g_n_video_bIsKeyFrame[ 1 ];

			if( g_pNetBroadcasterDlg->m_nNetworkServerStates_v[ 1 ] >= 0x00000001 ) {

				LeaveCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 1 ] );

				QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( g_pNetBroadcasterDlg->m_hNetworkServer[1], 0, pFrameBuffer, nFrameBufferSize, bIsKeyFrame );
			}
			else {

				LeaveCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 1 ] );
			}
		}
	}
	return 0x00000000;
}

DWORD WINAPI on_push_share_record_video_buffer_2( LPVOID params )
{
	HANDLE events[ 2 ] = { g_h_video_share_record_thread_stop_events[ 2 ], 

						   g_h_video_share_record_thread_buffer_ready_events[ 2 ] };
	while( TRUE ) {		

		DWORD returns = WaitForMultipleObjects( 2, events, FALSE, INFINITE );

		if( returns == (WAIT_OBJECT_0) ) { break ; }

		if( returns == (WAIT_OBJECT_0 + 1) ) {

			EnterCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 2 ] );

			BYTE * pFrameBuffer = g_p_video_frame_buffers[ 2 ];

			ULONG  nFrameBufferSize = g_n_video_frame_buffer_lens[ 2 ] ;

			ULONG  bIsKeyFrame = g_n_video_bIsKeyFrame[ 2 ];

			if( g_pNetBroadcasterDlg->m_nNetworkServerStates_v[ 2 ] >= 0x00000001 ) {

				LeaveCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 2 ] );

				QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( g_pNetBroadcasterDlg->m_hNetworkServer[2], 0, pFrameBuffer, nFrameBufferSize, bIsKeyFrame );
			}
			else {

				LeaveCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 2 ] );
			}
		}
	}
	return 0x00000000;
}

DWORD WINAPI on_push_share_record_video_buffer_3( LPVOID params )
{
	HANDLE events[ 2 ] = { g_h_video_share_record_thread_stop_events[ 3 ], 

						   g_h_video_share_record_thread_buffer_ready_events[ 3 ] };
	while( TRUE ) {		

		DWORD returns = WaitForMultipleObjects( 2, events, FALSE, INFINITE );

		if( returns == (WAIT_OBJECT_0) ) { break ; }

		if( returns == (WAIT_OBJECT_0 + 1) ) {

			EnterCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 3 ] );

			BYTE * pFrameBuffer = g_p_video_frame_buffers[ 3 ];

			ULONG  nFrameBufferSize = g_n_video_frame_buffer_lens[ 3 ] ;

			ULONG  bIsKeyFrame = g_n_video_bIsKeyFrame[ 3 ];

			if( g_pNetBroadcasterDlg->m_nNetworkServerStates_v[ 3 ] >= 0x00000001 ) {

				LeaveCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 3 ] );

				QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( g_pNetBroadcasterDlg->m_hNetworkServer[3], 0, pFrameBuffer, nFrameBufferSize, bIsKeyFrame );
			}
			else {

				LeaveCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ 3 ] );
			}
		}
	}
	return 0x00000000;
}

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	ULONG i = (ULONG)pUserData;

	g_pNetBroadcasterDlg->m_nVideoWidth[i] = 0;
	
	g_pNetBroadcasterDlg->m_nVideoHeight[i] = 0;
	
	g_pNetBroadcasterDlg->m_bVideoIsInterleaved[i] = FALSE;
	
	g_pNetBroadcasterDlg->m_dVideoFrameRate[i] = 0.0;
	
	g_pNetBroadcasterDlg->m_nAudioChannels[i] = 0; 
	
	g_pNetBroadcasterDlg->m_nAudioBitsPerSample[i] = 0;
	
	g_pNetBroadcasterDlg->m_nAudioSampleFrequency[i] = 0;

	g_pNetBroadcasterDlg->m_bNoSignal[ i ] = TRUE;

	g_pNetBroadcasterDlg->SetTimer( 0x00000000, 1, NULL );	

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	ULONG i = (ULONG)pUserData;

	g_pNetBroadcasterDlg->m_nVideoWidth[i] = 0;
	
	g_pNetBroadcasterDlg->m_nVideoHeight[i] = 0;
	
	g_pNetBroadcasterDlg->m_bVideoIsInterleaved[i] = FALSE;
	
	g_pNetBroadcasterDlg->m_dVideoFrameRate[i] = 0.0;
	
	g_pNetBroadcasterDlg->m_nAudioChannels[i] = 0; 
	
	g_pNetBroadcasterDlg->m_nAudioBitsPerSample[i] = 0;
	
	g_pNetBroadcasterDlg->m_nAudioSampleFrequency[i] = 0;

	g_pNetBroadcasterDlg->m_bNoSignal[ i ] = TRUE;

	g_pNetBroadcasterDlg->SetTimer( 0x00000000, 1, NULL );	

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	ULONG i = (ULONG)pUserData;

	g_pNetBroadcasterDlg->m_nVideoWidth[i] = nVideoWidth;
	
	g_pNetBroadcasterDlg->m_nVideoHeight[i] = nVideoHeight;
	
	g_pNetBroadcasterDlg->m_bVideoIsInterleaved[i] = bVideoIsInterleaved;
	
	g_pNetBroadcasterDlg->m_dVideoFrameRate[i] = dVideoFrameRate;
	
	g_pNetBroadcasterDlg->m_nAudioChannels[i] = nAudioChannels; 
	
	g_pNetBroadcasterDlg->m_nAudioBitsPerSample[i] = nAudioBitsPerSample;
	
	g_pNetBroadcasterDlg->m_nAudioSampleFrequency[i] = nAudioSampleFrequency;

	//info

	UINT nVH = 0;

	CHAR strFrameType[ MAX_PATH ] = { 0 }; 

	if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }
	
	g_pNetBroadcasterDlg->m_strFormatChangedOutput[ i ].Format( "INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ",

													nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels,

													nAudioBitsPerSample, nAudioSampleFrequency); 

	//m_bNoSignal

	if ( nVideoWidth == 0 && nVideoHeight == 0 && dVideoFrameRate == 0.0 && nAudioChannels == 0 && nAudioBitsPerSample == 0 && nAudioSampleFrequency == 0 )
	{
		g_pNetBroadcasterDlg->m_bNoSignal[ i ] = TRUE;		
	}
    else {

		g_pNetBroadcasterDlg->m_bNoSignal[ i ] = FALSE;		
    }

	g_pNetBroadcasterDlg->SetTimer( 0x00000000, 1, NULL );	

	return QCAP_RT_OK;
}


QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	return QCAP_RT_OK;
}

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	ULONG i = (ULONG)pUserData;

	//SC_DEBUG("g_pNetBroadcasterDlg->m_nNetworkServerStates[ %d ] = %d", i, g_pNetBroadcasterDlg->m_nNetworkServerStates[ i ]);

	EnterCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_a[ i ] );

	if( g_pNetBroadcasterDlg->m_nNetworkServerStates_a[ i ] >= 0x00000001 ) {

		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( g_pNetBroadcasterDlg->m_hNetworkServer[i], 0, pFrameBuffer, nFrameBufferLen );
	}
	LeaveCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_a[ i ] );

    return QCAP_RT_OK;
}

QRETURN on_video_m_hardware_encoder_callback( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, BOOL bIsKeyFrame, PVOID pUserData)
{
	ULONG i = (ULONG)pUserData;


	EnterCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ i ] );

	if( g_pNetBroadcasterDlg->m_nNetworkServerStates_v[ i ] >= 0x00000001 ) {

		//QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( g_pNetBroadcasterDlg->m_hNetworkServer[i], 0, pStreamBuffer, nStreamBufferLen, bIsKeyFrame );

		g_p_video_frame_buffers[ i ] = pStreamBuffer;

		g_n_video_frame_buffer_lens[ i ] = nStreamBufferLen;

		g_n_video_bIsKeyFrame[ i ] = bIsKeyFrame;

		if( g_h_video_share_record_thread_buffer_ready_events[ i ] ) {

			SetEvent( g_h_video_share_record_thread_buffer_ready_events[ i ] );
		}

	}
	LeaveCriticalSection( &g_pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSections_v[ i ] );

	return QCAP_RT_OK;
}

extern CNetBroadcasterApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBroadcasterDlg dialog

CNetBroadcasterDlg::CNetBroadcasterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetBroadcasterDlg::IDD, pParent)
	, m_nPort_RTMP1(1935)
	, m_nPort_RTMP2(1930)
	, m_nPort_RTMP3(1925)
	, m_nPort_RTMP4(1920)
	, m_nPort_RTMPOverHTTP1(8080)
	, m_nPort_RTMPOverHTTP2(8000)
	, m_nPort_RTMPOverHTTP3(8888)
	, m_nPort_RTMPOverHTTP4(7002)
{
	//{{AFX_DATA_INIT(CNetBroadcasterDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNetBroadcasterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetBroadcasterDlg)
	DDX_Control(pDX, IDC_STATIC_FORMAT, m_statFormat);
	DDX_Control(pDX, IDC_STATIC_DISPLAY_WINDOW, m_statDisplayWindow);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_STATIC_DISPLAY_WINDOW2, m_statDisplayWindow2);
	DDX_Control(pDX, IDC_STATIC_DISPLAY_WINDOW3, m_statDisplayWindow3);
	DDX_Control(pDX, IDC_STATIC_DISPLAY_WINDOW4, m_statDisplayWindow4);
	DDX_Control(pDX, IDC_STATIC_FORMAT2, m_statFormat2);
	DDX_Control(pDX, IDC_STATIC_FORMAT3, m_statFormat3);
	DDX_Control(pDX, IDC_STATIC_FORMAT4, m_statFormat4);
	DDX_Text(pDX, IDC_EDIT_RTMP1, m_nPort_RTMP1);
	DDV_MinMaxUInt(pDX, m_nPort_RTMP1, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_RTMP2, m_nPort_RTMP2);
	DDV_MinMaxUInt(pDX, m_nPort_RTMP2, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_RTMP3, m_nPort_RTMP3);
	DDV_MinMaxUInt(pDX, m_nPort_RTMP3, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_RTMP4, m_nPort_RTMP4);
	DDV_MinMaxUInt(pDX, m_nPort_RTMP4, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_RTMP_HTTP1, m_nPort_RTMPOverHTTP1);
	DDV_MinMaxUInt(pDX, m_nPort_RTMPOverHTTP1, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_RTMP_HTTP2, m_nPort_RTMPOverHTTP2);
	DDV_MinMaxUInt(pDX, m_nPort_RTMPOverHTTP2, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_RTMP_HTTP3, m_nPort_RTMPOverHTTP3);
	DDV_MinMaxUInt(pDX, m_nPort_RTMPOverHTTP3, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_RTMP_HTTP4, m_nPort_RTMPOverHTTP4);
	DDV_MinMaxUInt(pDX, m_nPort_RTMPOverHTTP4, 0, 65535);
}

BEGIN_MESSAGE_MAP(CNetBroadcasterDlg, CDialog)
	//{{AFX_MSG_MAP(CNetBroadcasterDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_START2, &CNetBroadcasterDlg::OnBnClickedButtonStart2)
	ON_BN_CLICKED(IDC_BUTTON_STOP2, &CNetBroadcasterDlg::OnBnClickedButtonStop2)
	ON_BN_CLICKED(IDC_BUTTON_START3, &CNetBroadcasterDlg::OnBnClickedButtonStart3)
	ON_BN_CLICKED(IDC_BUTTON_STOP3, &CNetBroadcasterDlg::OnBnClickedButtonStop3)
	ON_BN_CLICKED(IDC_BUTTON_START4, &CNetBroadcasterDlg::OnBnClickedButtonStart4)
	ON_BN_CLICKED(IDC_BUTTON_STOP4, &CNetBroadcasterDlg::OnBnClickedButtonStop4)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBroadcasterDlg message handlers

BOOL CNetBroadcasterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	g_pNetBroadcasterDlg = this;

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//

	for ( ULONG i = 0; i < 4; i++ ) {

		m_pDevice[i] = NULL;

		m_nVideoWidth[i] = 0;
	
		m_nVideoHeight[i] = 0;
	
		m_bVideoIsInterleaved[i] = FALSE;
	
		m_dVideoFrameRate[i] = 0.0;
	
		m_nAudioChannels[i] = 0; 
	
		m_nAudioBitsPerSample[i] = 0;
	
		m_nAudioSampleFrequency[i] = 0;

		m_hNetworkServer[i] = NULL;

		m_nNetworkServerStates_v[ i ] = 0x00000000;

		m_nNetworkServerStates_a[ i ] = 0x00000000;

		m_bNoSignal[i] = TRUE;

		InitializeCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ i ] );

		InitializeCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ i ] );
	}
	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_START2 )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP2 )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_START3 )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP3 )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_START4 )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP4 )->EnableWindow( FALSE );

	UpdateData( FALSE );

	// INITIALIZE DEVICE RESOURCE
	//

	QCAP_CREATE( "QP0203 PCI", 0, m_statDisplayWindow.m_hWnd, &m_pDevice[0], TRUE );

	QCAP_CREATE( "QP0203 PCI", 1, m_statDisplayWindow2.m_hWnd, &m_pDevice[1], TRUE );

	QCAP_CREATE( "QP0203 PCI", 2, m_statDisplayWindow3.m_hWnd, &m_pDevice[2], TRUE );

	QCAP_CREATE( "QP0203 PCI", 3, m_statDisplayWindow4.m_hWnd, &m_pDevice[3], TRUE );

	for ( ULONG i = 0; i < 4; i++ ) 
	{
		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice[i], on_format_changed_callback, (PVOID)i );

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice[i], on_no_signal_detected_callback, (PVOID)i );

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice[i], on_no_signal_removed_callback, (PVOID)i );

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice[i], on_video_preview_callback, (PVOID)i );

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice[i], on_audio_preview_callback, (PVOID)i );

		QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( m_pDevice[ i ], 0, on_video_m_hardware_encoder_callback, (PVOID)i );

		QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_pDevice[ i ], 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF, 0, 0);

		QCAP_SET_VIDEO_INPUT( m_pDevice[i], QCAP_INPUT_TYPE_AUTO );

		QCAP_SET_AUDIO_INPUT( m_pDevice[i], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

		QCAP_SET_AUDIO_VOLUME( m_pDevice[i], 0 );

		QCAP_RUN( m_pDevice[i] );
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNetBroadcasterDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	// UNINITIALIZE DEVICE RESOURCE
	//

	OnButtonStop();

	OnBnClickedButtonStop2();

	OnBnClickedButtonStop3();

	OnBnClickedButtonStop4();

	for ( ULONG i = 0; i < 4; i++ ) {

		if( m_pDevice[i] ) {

			QCAP_STOP( m_pDevice[i] );

			QCAP_DESTROY( m_pDevice[i] );

			m_pDevice[i] = NULL;
		}

	}

	// UNINITIALIZE MEMBER VARIABLES
	//
	UpdateData( TRUE );

	for(ULONG i = 0 ; i < 4 ; i ++)
	{
		DeleteCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ i ] );

		DeleteCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ i ] );
	}

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

void CNetBroadcasterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetBroadcasterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetBroadcasterDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CNetBroadcasterDlg::OnButtonStart() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	OnButtonStop();

	if( m_nVideoWidth[0] == 0 ) { return ; }

	if( m_nVideoHeight[0] == 0 ) { return ; }


	g_h_video_share_record_thread_stop_events[ 0 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	g_h_video_share_record_thread_buffer_ready_events[ 0 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	g_push_share_record_video_threads[ 0 ] = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)(on_push_share_record_video_buffer_0), (LPVOID)(this), 0, NULL );
	
	g_p_video_frame_buffers[ 0 ] = NULL;

	g_n_video_frame_buffer_lens[ 0 ] = 0;

	g_n_video_bIsKeyFrame[ 0 ] = 0;


	QCAP_CREATE_BROADCAST_RTMP_SERVER( 0, 1 /*1 CHANNELS*/, &m_hNetworkServer[0], NULL, NULL, m_nPort_RTMP1, m_nPort_RTMPOverHTTP1 );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[0], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth[0] >> 0, m_nVideoHeight[0] >> 0, 30, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[0], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels[0], m_nAudioBitsPerSample[0], m_nAudioSampleFrequency[0] );

	QCAP_START_BROADCAST_SERVER( m_hNetworkServer[0] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 0 ] );

	m_nNetworkServerStates_v[ 0 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 0 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 0 ] );

	m_nNetworkServerStates_a[ 0 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 0 ] );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( TRUE );
}

void CNetBroadcasterDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 0 ] );

	m_nNetworkServerStates_v[ 0 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 0 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 0 ] );

	m_nNetworkServerStates_a[ 0 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 0 ] );

	if ( m_hNetworkServer[0] != NULL ) {

		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[0] );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[0] );

		m_hNetworkServer[0] = NULL;
	}

	if( g_h_video_share_record_thread_stop_events[ 0 ] ) { 
			
		SetEvent( g_h_video_share_record_thread_stop_events[ 0 ] ); 
	}
	CLOSE_THREAD( g_push_share_record_video_threads[ 0 ] );

	if( g_h_video_share_record_thread_stop_events[ 0 ] != NULL ) {

		CloseHandle( g_h_video_share_record_thread_stop_events[ 0 ] );

		g_h_video_share_record_thread_stop_events[ 0 ] = NULL;
	}
	if( g_h_video_share_record_thread_buffer_ready_events[ 0 ] != NULL ) {

		CloseHandle( g_h_video_share_record_thread_buffer_ready_events[ 0 ] );

		g_h_video_share_record_thread_buffer_ready_events[ 0 ] = NULL;
	}

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );
}


void CNetBroadcasterDlg::OnBnClickedButtonStart2()
{
	// TODO: Add your control notification handler code here
	UpdateData( TRUE );

	OnBnClickedButtonStop2();

	if( m_nVideoWidth[1] == 0 ) { return ; }

	if( m_nVideoHeight[1] == 0 ) { return ; }

	g_h_video_share_record_thread_stop_events[ 1 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	g_h_video_share_record_thread_buffer_ready_events[ 1 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	g_push_share_record_video_threads[ 1 ] = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)(on_push_share_record_video_buffer_1), (LPVOID)(this), 0, NULL );
	
	g_p_video_frame_buffers[ 1 ] = NULL;

	g_n_video_frame_buffer_lens[ 1 ] = 0;

	g_n_video_bIsKeyFrame[ 1 ] = 0;

	QCAP_CREATE_BROADCAST_RTMP_SERVER( 1, 1 /*1 CHANNELS*/, &m_hNetworkServer[1], NULL, NULL, m_nPort_RTMP2, m_nPort_RTMPOverHTTP2 );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[1], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth[1] >> 0, m_nVideoHeight[1] >> 0, 30, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[1], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels[1], m_nAudioBitsPerSample[1], m_nAudioSampleFrequency[1] );

	QCAP_START_BROADCAST_SERVER( m_hNetworkServer[1] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 1 ] );

	m_nNetworkServerStates_v[ 1 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 1 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 1 ] );

	m_nNetworkServerStates_a[ 1 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 1 ] );

	GetDlgItem( IDC_BUTTON_START2 )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP2 )->EnableWindow( TRUE );
}


void CNetBroadcasterDlg::OnBnClickedButtonStop2()
{
	// TODO: Add your control notification handler code here

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 1 ] );

	m_nNetworkServerStates_v[ 1 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 1 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 1 ] );

	m_nNetworkServerStates_a[ 1 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 1 ] );

	if ( m_hNetworkServer[1] != NULL ) {

		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[1] );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[1] );

		m_hNetworkServer[1] = NULL;
	}

	if( g_h_video_share_record_thread_stop_events[ 1 ] ) { 
			
		SetEvent( g_h_video_share_record_thread_stop_events[ 1 ] ); 
	}
	CLOSE_THREAD( g_push_share_record_video_threads[ 1 ] );

	if( g_h_video_share_record_thread_stop_events[ 1 ] != NULL ) {

		CloseHandle( g_h_video_share_record_thread_stop_events[ 1 ] );

		g_h_video_share_record_thread_stop_events[ 1 ] = NULL;
	}
	if( g_h_video_share_record_thread_buffer_ready_events[ 1 ] != NULL ) {

		CloseHandle( g_h_video_share_record_thread_buffer_ready_events[ 1 ] );

		g_h_video_share_record_thread_buffer_ready_events[ 1 ] = NULL;
	}

	GetDlgItem( IDC_BUTTON_START2 )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP2 )->EnableWindow( FALSE );
}


void CNetBroadcasterDlg::OnBnClickedButtonStart3()
{
	// TODO: Add your control notification handler code here
	UpdateData( TRUE );

	OnBnClickedButtonStop3();

	if( m_nVideoWidth[2] == 0 ) { return ; }

	if( m_nVideoHeight[2] == 0 ) { return ; }

	g_h_video_share_record_thread_stop_events[ 2 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	g_h_video_share_record_thread_buffer_ready_events[ 2 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	g_push_share_record_video_threads[ 2 ] = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)(on_push_share_record_video_buffer_2), (LPVOID)(this), 0, NULL );
	
	g_p_video_frame_buffers[ 2 ] = NULL;

	g_n_video_frame_buffer_lens[ 2 ] = 0;

	g_n_video_bIsKeyFrame[ 2 ] = 0;

	QCAP_CREATE_BROADCAST_RTMP_SERVER( 2, 1 /*1 CHANNELS*/, &m_hNetworkServer[2], NULL, NULL, m_nPort_RTMP3, m_nPort_RTMPOverHTTP3 );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[2], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth[2] >> 0, m_nVideoHeight[2] >> 0, 30, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[2], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels[2], m_nAudioBitsPerSample[2], m_nAudioSampleFrequency[2] );

	QCAP_START_BROADCAST_SERVER( m_hNetworkServer[2] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 2 ] );

	m_nNetworkServerStates_v[ 2 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 2 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 2 ] );

	m_nNetworkServerStates_a[ 2 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 2 ] );

	GetDlgItem( IDC_BUTTON_START3 )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP3 )->EnableWindow( TRUE );
}


void CNetBroadcasterDlg::OnBnClickedButtonStop3()
{
	// TODO: Add your control notification handler code here
	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 2 ] );

	m_nNetworkServerStates_v[ 2 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 2 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 2 ] );

	m_nNetworkServerStates_a[ 2 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 2 ] );

	if ( m_hNetworkServer[2] != NULL ) {

		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[2] );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[2] );

		m_hNetworkServer[2] = NULL;
	}

	if( g_h_video_share_record_thread_stop_events[ 2 ] ) { 
			
		SetEvent( g_h_video_share_record_thread_stop_events[ 2 ] ); 
	}
	CLOSE_THREAD( g_push_share_record_video_threads[ 2 ] );

	if( g_h_video_share_record_thread_stop_events[ 2 ] != NULL ) {

		CloseHandle( g_h_video_share_record_thread_stop_events[ 2 ] );

		g_h_video_share_record_thread_stop_events[ 2 ] = NULL;
	}
	if( g_h_video_share_record_thread_buffer_ready_events[ 2 ] != NULL ) {

		CloseHandle( g_h_video_share_record_thread_buffer_ready_events[ 2 ] );

		g_h_video_share_record_thread_buffer_ready_events[ 2 ] = NULL;
	}

	GetDlgItem( IDC_BUTTON_START3 )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP3 )->EnableWindow( FALSE );
}


void CNetBroadcasterDlg::OnBnClickedButtonStart4()
{
	// TODO: Add your control notification handler code here
	UpdateData( TRUE );

	OnBnClickedButtonStop4();

	if( m_nVideoWidth[3] == 0 ) { return ; }

	if( m_nVideoHeight[3] == 0 ) { return ; }

	g_h_video_share_record_thread_stop_events[ 3 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	g_h_video_share_record_thread_buffer_ready_events[ 3 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	g_push_share_record_video_threads[ 3 ] = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)(on_push_share_record_video_buffer_3), (LPVOID)(this), 0, NULL );
	
	g_p_video_frame_buffers[ 3 ] = NULL;

	g_n_video_frame_buffer_lens[ 3 ] = 0;

	g_n_video_bIsKeyFrame[ 3 ] = 0;

	QCAP_CREATE_BROADCAST_RTMP_SERVER( 3, 1 /*1 CHANNELS*/, &m_hNetworkServer[3], NULL, NULL, m_nPort_RTMP4, m_nPort_RTMPOverHTTP4 );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[3], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth[3] >> 0, m_nVideoHeight[3] >> 0, 30, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[3], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels[3], m_nAudioBitsPerSample[3], m_nAudioSampleFrequency[3] );

	QCAP_START_BROADCAST_SERVER( m_hNetworkServer[3] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 3 ] );

	m_nNetworkServerStates_v[ 3 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 3 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 3 ] );

	m_nNetworkServerStates_a[ 3 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 3 ] );

	GetDlgItem( IDC_BUTTON_START4 )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP4 )->EnableWindow( TRUE );
}


void CNetBroadcasterDlg::OnBnClickedButtonStop4()
{
	// TODO: Add your control notification handler code here
	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 3 ] );

	m_nNetworkServerStates_v[ 3 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_v[ 3 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 3 ] );

	m_nNetworkServerStates_a[ 3 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections_a[ 3 ] );

	if ( m_hNetworkServer[3] != NULL ) {

		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[3] );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[3] );

		m_hNetworkServer[3] = NULL;
	}

	if( g_h_video_share_record_thread_stop_events[ 3 ] ) { 
			
		SetEvent( g_h_video_share_record_thread_stop_events[ 3 ] ); 
	}
	CLOSE_THREAD( g_push_share_record_video_threads[ 3 ] );

	if( g_h_video_share_record_thread_stop_events[ 3 ] != NULL ) {

		CloseHandle( g_h_video_share_record_thread_stop_events[ 3 ] );

		g_h_video_share_record_thread_stop_events[ 3 ] = NULL;
	}
	if( g_h_video_share_record_thread_buffer_ready_events[ 3 ] != NULL ) {

		CloseHandle( g_h_video_share_record_thread_buffer_ready_events[ 3 ] );

		g_h_video_share_record_thread_buffer_ready_events[ 3 ] = NULL;
	}

	GetDlgItem( IDC_BUTTON_START4 )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP4 )->EnableWindow( FALSE );
}

void CNetBroadcasterDlg::OnTimer(UINT nIDEvent) 
{
	if( nIDEvent == 0x00000000 )
	{
		KillTimer( 0x00000000 );

		for ( ULONG i = 0; i < 4; i++ ) 
		{			

			if ( m_bNoSignal[ i ] ) {				

				if ( i == 0 ) { m_statFormat.SetWindowText( _T("INFO :...") ); }

				if ( i == 1 ) { m_statFormat2.SetWindowText( _T("INFO :...") ); }

				if ( i == 2 ) { m_statFormat3.SetWindowText( _T("INFO :...") ); }

				if ( i == 3 ) { m_statFormat4.SetWindowText( _T("INFO :...") ); }
			}
			else {

				if ( i == 0 ) { m_statFormat.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 0 ] ); }

				if ( i == 1 ) { m_statFormat2.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 1 ] ); }

				if ( i == 2 ) { m_statFormat3.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 2 ] ); }

				if ( i == 3 ) { m_statFormat4.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 3 ] ); }
			}	
		}
	}

	CDialog::OnTimer(nIDEvent);
}